%if %{?rhel}%{!?rhel:0} <= 5
  %global _initddir  %{_initrddir}
%endif

Name: fetch-crl
Version: 2.8.6
Release: 1%{?dist}
Summary: Downloads Certificate Revocation Lists

Group: Applications/System
License: EU DataGrid
URL: https://dist.eugridpma.info/distribution/util/%{name}
Source: http://www.eugridpma.org/distribution/util/%{name}/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch: noarch

Requires: openssl
Requires: wget

#Prefix: /usr

Requires(post): chkconfig
Requires(preun): chkconfig

%description
This tool and associated cron entry ensure that Certificate Revocation 
Lists (CRLs) are periodically retrieved from the web sites of the respective 
Certification Authorities.
It assumes that the installed CA files follow the hash.crl_url convention.

%prep

%setup -q

%build

%clean
rm -rf $RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
make install PREFIX=$RPM_BUILD_ROOT%{_usr} ETC=$RPM_BUILD_ROOT/%{_sysconfdir}
mkdir -p $RPM_BUILD_ROOT%{_initddir}
install -p -m 755 $RPM_BUILD_ROOT%{_usr}/share/doc/%{name}-%{version}/%{name}-cron.init $RPM_BUILD_ROOT%{_initddir}/%{name}-cron
install -p -m 755 $RPM_BUILD_ROOT%{_usr}/share/doc/%{name}-%{version}/%{name}-boot.init $RPM_BUILD_ROOT%{_initddir}/%{name}-boot
mkdir $RPM_BUILD_ROOT%{_sysconfdir}/cron.d
install -p -m 644 $RPM_BUILD_ROOT%{_usr}/share/doc/%{name}-%{version}/%{name}-cron.cron $RPM_BUILD_ROOT%{_sysconfdir}/cron.d/%{name}

# Remove some files that have been duplicated as docs.
rm $RPM_BUILD_ROOT%{_defaultdocdir}/%{name}-%{version}/%{name}-boot.init
rm $RPM_BUILD_ROOT%{_defaultdocdir}/%{name}-%{version}/%{name}-cron.cron
rm $RPM_BUILD_ROOT%{_defaultdocdir}/%{name}-%{version}/%{name}-cron.init
rm $RPM_BUILD_ROOT%{_defaultdocdir}/%{name}-%{version}/%{name}.cron
rm $RPM_BUILD_ROOT%{_defaultdocdir}/%{name}-%{version}/%{name}.sysconfig

%post
# This adds the proper /etc/rc*.d links for the script
/sbin/chkconfig --add %{name}-cron
/sbin/chkconfig --add %{name}-boot

%preun
if [ $1 = 0 ] ; then
    /sbin/service %{name}-cron stop >/dev/null 2>&1
    /sbin/service %{name}-boot stop  >/dev/null 2>&1
    /sbin/chkconfig --del %{name}-cron
    /sbin/chkconfig --del %{name}-boot
fi


%files
%defattr(-,root,root,-)
%{_sbindir}/%{name}
%{_initddir}/%{name}-cron
%{_initddir}/%{name}-boot
%doc /usr/share/man/man8/%{name}.8.gz
%doc %{_defaultdocdir}/%{name}-%{version}
%config(noreplace) %{_sysconfdir}/%{name}.conf
%config(noreplace) %{_sysconfdir}/cron.d/%{name}


%changelog
* Wed Mar 3 2010 David Groep <davidg@nikhef.nl>
- imported patches by Steve Traylen (below) back into EUGridPMA trunk in 2.8.2
* Mon Feb 22 2010 Steve Traylen <steve.traylen@cern.ch> - 2.8.1-4
- Correct URL again.
* Mon Feb 22 2010 Steve Traylen <steve.traylen@cern.ch> - 2.8.1-3
- Use consistant name macros throughout.
- Rename /etc/cron.d/fetch-crl.cron to /etc/cron.d/fetch-crl to
be compliant with some cron implentations.
- Remove dupicate files created in doc directory.
* Thu Feb 11 2010 Steve Traylen <steve.traylen@cern.ch> - 2.8.1-2
- Add patch to introduce --randomwait option.
- Make setup stage quiet.
- Change license string from EU DataGrid to EU Datagrid
- First version for Fedora/EPEL inclusion.
* Tue Sep 22 2009 David Groep <davidg@nikhef.nl>
Version 2.8.1 is more paranoid about the installed fetch-crl to catch OS faults
* Tue Sep 22 2009 David Groep <davidg@nikhef.nl>
Version 2.8.0 with new config file location, start-up scripts, and packaging
* Sun Jan 25 2009 David Groep <davidg@nikhef.nl>
Version 2.7.0 with new policies, download resiliancy, PATH support, etc
* Thu Oct 27 2005 David Groep <davidg@nikhef.nl>
Wget https downloads recognise our own trusted CA directory (by RomainW)
* Mon Feb 28 2005 David Groep <davidg@nikhef.nl>
Made into a relocatable RPM without the cronjob pre-installed
* Mon Dec  6 2004 David Groep <davidg@nikhef.nl>
Copied to EUGridPMA site
* Wed Jan 15 2003 Steve Traylen <s.m.traylen@rl.ac.uk>
Initial Build
